
(setf *print-doco-mode* nil)


(defun print-help-topics ()
  (set-working-directory *default-path*)
  (setf *print-doco-mode* t)
  (let* ((outfile "doco.txt")
         (actions-list (actions-list))
         (infile-list)
         (title-list)
         )
    (with-open-file 
     (outstream outfile :direction :output)
     (setf *print-doco-mode* t)
     (dolist (i (iseq 2 (length actions-list)))
             (format outstream "~d: ~a~%"i (string-capitalize (select (topic-list) i)))
             (format t "~d: ~a~%"i (string-capitalize (select (topic-list) i)))
             (dotimes (j (1- (length (select actions-list i))))
                      (format outstream "~d.~d:   ~A~%" i j
                          (string-capitalize (select (select (subtopics-list) i) j)))
                      (format t "~d.~d:   ~A~%" i j
                          (string-capitalize (select (select (subtopics-list) i) j)))
                      (setf title 
                            (send (eval (select (select actions-list i) j)) :title))
                      (setf title-list (append title-list (list title)))
                      (setf infile 
                            (send (eval (select (select actions-list i) j)) :file))
                      (setf infile-list (append infile-list (list infile)))
                      ))
     (print-documentation infile-list title-list outfile)
     )))




(defun print-documentation (infile-list outfile)
  (let* ((text-line)(text-list))
    (with-open-file (outstream outfile :direction :output)
                    (mapcar #'(lambda (infile)
                                (with-open-file (instream infile :direction :input)
                                                (loop
                                                 (setf text-line 
                                                       (read-line instream nil nil))
                                                 (unless text-line (return))
                                                 (setf text-list 
                                                       (append text-list 
                                                               (list (list text-line)))))
                                                (paragraph-text-list-to-text-stream
                                                 text-list infile outstream)
                                                (setf text-list nil)
                                                ))
                            infile-list))
    ))
             

(defun paragraph-text-list-to-text-stream (intext intitle outstream )
  (let ((num-strings (length intext))
        (oldbreak *breakenable*))
    (setq *breakenable* nil)
    (unwind-protect 
     (format outstream "______________________________~% |~% |~a~% |______________________________~%~%" intitle)
             (string-upcase intitle))
     (dotimes (i num-strings)
              (format outstream "~a~%"  (first (select intext i))))
     (format outstream "~%~%~%~%~%")
    (setq *breakenable* oldbreak)))


(defun paragraph-text-list-to-html-stream (intext intitle outstream)
  (let ((num-strings (length intext))
        (oldbreak *breakenable*))
    (setq *breakenable* nil)
    (unwind-protect 
     (format outstream "______________________________~% |~% |~a~% |______________________________~%~%" intitle)
             (string-upcase intitle))
     (dotimes (i num-strings)
              (format outstream "~a~%"  (first (select intext i))))
     (format outstream "~%~%~%~%~%")
    (setq *breakenable* oldbreak)))

#|in display3.lsp


(defun file-to-window 
	(filename title window &optional (flush t) (add-help t) (fit t) (show t))
"Args: filename title window &optional (flush t) (add-help t) (fit t) (show t)
Depending on value of global variable *linked-window*, constructs a help or chain window (not reports) from text in a file. All text must come from a file via this function for the help and chained windows systems to work right."
    (when *file-verbose* (format t "; reading ~a~%" filename))
  (let ((w
         (cond 
           (*linked-window* 
            (setf *linked-window* nil)
            (file-to-chain-window  filename title window flush add-help fit show))
           (t
            (file-to-single-window filename title window flush add-help fit show)))))
    (send w :add-slot 'file filename)
    (defmeth w :file (&optional (name nil set))
      (if set (setf (slot-value 'file) name))
      (slot-value 'file))
    w))

(defmeth display-window-proto2 :set-window-parameters (fit show)
  (let* ((height)
         )
    (if fit (setf height (send self :get-height-to-fit-window-to-text))
        (setf height (second (send self :size))))
    (when (and (not *print-doco-mode*) show (> (send self  :nlines) 0)) 
          (send self :size (first (send self :size)) height)
          (send self :show-window :relocate nil))
    (send self :top-most *help-window-top-most?*)
    (send self :top-most? *help-window-top-most?*)
    (send self :buffer-to-screen)
    (send self :scroll 0 0)
    (send self :used? t)
    self))|#